
#ifndef _DAC_H_
#define _DAC_H_

#include "types.h"

#define DAC_BUFFER_PAGES 10
extern volatile unsigned char DACBuffer_full, DACBuffer_empty;

void dac_init();
unsigned char dac_set_sample_rate(unsigned short rate);
void dac_start_playback();
void dac_stop_playback();
void dac_write(signed short* data, unsigned char num_channels, unsigned short volume);
void dac_pause(bool Paused);
void dac_clear_buffer();
void dac_reset_buffer();
unsigned char* dac_get_buffer();
bool dac_is_running();
unsigned char dac_get_free_buffers();

#endif//_DAC_H_
